/**
* \file: signature_db.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* \component: authorization level daemon
*
* \author: Marko Hoyer / ADIT / SWGII / mhoyer@de.adit-jv.com
*
* \copyright (c) 2010, 2011 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
*
***********************************************************************/
#ifndef ALD_MODEL_SIGNATURE_DB_H
#define ALD_MODEL_SIGNATURE_DB_H

#include <stdbool.h>
#include <stdint.h>

#include <encryption/signature.h>
#include "ald_types.h"

//---------------------------------- public data structures ----------------------------------------------------------
typedef struct serialized_signature_db_entry_t
{
	char signature[RESPONSE_SIGNATURE_SIZE_USED];
	uint32_t path_len;
	char path[];
} __attribute__((aligned(4),packed)) serialized_signature_db_entry_t;

typedef struct signature_db_entry_t signature_db_entry_t;

//---------------------------------- loading and destroy -------------------------------------------------------------
error_code_t signature_db_load(void);

void signature_db_deinit(void);
//--------------------------------------------------------------------------------------------------------------------

//---------------------------------- checking signature of a script --------------------------------------------------
bool signature_db_validate_script(const char *path);

bool signature_db_is_script_available(const char *path);
//--------------------------------------------------------------------------------------------------------------------

#endif
